<?php
/**
 * Tap and Try Uninstall
 *
 * Fired when the plugin is uninstalled.
 *
 * @package TapAndTry
 * @since 1.0.0
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('tnt_api_key');
delete_option('tnt_button_text');
delete_option('tnt_button_position');
delete_option('tnt_auto_sync');
delete_option('tnt_marketplace_enabled');

// Delete product meta for all products
global $wpdb;
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_tnt_%'");

// Clear any transients
delete_transient('tnt_account_info');
delete_transient('tnt_products_cache');

// Note: We intentionally do NOT delete user data from the Tap and Try service
// Users can manage their account data directly at tapandtry.com
