<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap tnt-admin">
    <h1><?php _e('Tap and Try Settings', 'tap-and-try'); ?></h1>
    
    <!-- Upgrade Warning Banner (shown when over limit) -->
    <div id="tnt-settings-upgrade-banner" class="tnt-card tnt-upgrade-banner" style="display: none; margin-bottom: 20px;">
        <div class="tnt-upgrade-content">
            <div class="tnt-upgrade-icon">
                <span class="dashicons dashicons-warning"></span>
            </div>
            <div class="tnt-upgrade-text">
                <h3><?php _e('Product Limit Reached', 'tap-and-try'); ?></h3>
                <p id="tnt-settings-upgrade-message"><?php _e('You have reached your plan\'s product limit.', 'tap-and-try'); ?></p>
            </div>
            <div class="tnt-upgrade-action">
                <button type="button" class="button tnt-upgrade-btn" onclick="tntOpenUpgrade('/pricing')">
                    <?php _e('Upgrade Plan', 'tap-and-try'); ?>
                </button>
            </div>
        </div>
    </div>
    
    <form method="post" action="options.php">
        <?php settings_fields('tnt_settings'); ?>
        
        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="tnt_api_key"><?php _e('API Key', 'tap-and-try'); ?></label>
                </th>
                <td>
                    <input type="password" 
                           id="tnt_api_key" 
                           name="tnt_api_key" 
                           value="<?php echo esc_attr(get_option('tnt_api_key', '')); ?>" 
                           class="regular-text"
                           placeholder="tt_live_xxxxxxxxxxxx">
                    <p class="description">
                        <?php _e('Enter your Tap and Try API key.', 'tap-and-try'); ?>
                        <a href="https://tapandtry.com/register" target="_blank"><?php _e('Get your API key', 'tap-and-try'); ?></a>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="tnt_button_text"><?php _e('Button Text', 'tap-and-try'); ?></label>
                </th>
                <td>
                    <input type="text" 
                           id="tnt_button_text" 
                           name="tnt_button_text" 
                           value="<?php echo esc_attr(get_option('tnt_button_text', 'Tap & Try It')); ?>" 
                           class="regular-text">
                    <p class="description">
                        <?php _e('Text displayed on the try-on button.', 'tap-and-try'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="tnt_checkout_type"><?php _e('Buy Button Action', 'tap-and-try'); ?></label>
                </th>
                <td>
                    <select id="tnt_checkout_type" name="tnt_checkout_type">
                        <option value="product_page" <?php selected(get_option('tnt_checkout_type', 'product_page'), 'product_page'); ?>>
                            <?php _e('Go to Product Page (recommended for variable products)', 'tap-and-try'); ?>
                        </option>
                        <option value="add_to_cart" <?php selected(get_option('tnt_checkout_type'), 'add_to_cart'); ?>>
                            <?php _e('Add to Cart directly (simple products only)', 'tap-and-try'); ?>
                        </option>
                    </select>
                    <p class="description">
                        <?php _e('What happens when customers click "Buy" in the Tap & Try visualizer.', 'tap-and-try'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="tnt_button_position"><?php _e('Button Position', 'tap-and-try'); ?></label>
                </th>
                <td>
                    <select id="tnt_button_position" name="tnt_button_position">
                        <option value="after_add_to_cart" <?php selected(get_option('tnt_button_position'), 'after_add_to_cart'); ?>>
                            <?php _e('After Add to Cart button', 'tap-and-try'); ?>
                        </option>
                        <option value="before_add_to_cart" <?php selected(get_option('tnt_button_position'), 'before_add_to_cart'); ?>>
                            <?php _e('Before Add to Cart button', 'tap-and-try'); ?>
                        </option>
                        <option value="after_price" <?php selected(get_option('tnt_button_position'), 'after_price'); ?>>
                            <?php _e('After price', 'tap-and-try'); ?>
                        </option>
                        <option value="shortcode" <?php selected(get_option('tnt_button_position'), 'shortcode'); ?>>
                            <?php _e('Manual (use shortcode)', 'tap-and-try'); ?>
                        </option>
                    </select>
                    <p class="description">
                        <?php _e('Where to display the try-on button on product pages.', 'tap-and-try'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php _e('Default Settings', 'tap-and-try'); ?></th>
                <td>
                    <fieldset>
                        <label>
                            <input type="checkbox" 
                                   name="tnt_marketplace_visible" 
                                   value="1" 
                                   <?php checked(get_option('tnt_marketplace_visible'), 1); ?>>
                            <?php _e('Show new products in Tap and Try Marketplace by default', 'tap-and-try'); ?>
                        </label>
                        <p class="description">
                            <?php _e('When enabled, synced products will be visible on tapandtry.com for additional exposure.', 'tap-and-try'); ?>
                        </p>
                    </fieldset>
                </td>
            </tr>
        </table>
        
        <?php submit_button(); ?>
    </form>
    
    <hr>
    
    <h2><?php _e('Shortcode Usage', 'tap-and-try'); ?></h2>
    <p><?php _e('You can manually place the try-on button anywhere using the shortcode:', 'tap-and-try'); ?></p>
    <code>[tapandtry product_id="YOUR_PRODUCT_ID"]</code>
    <p><?php _e('Or with a custom button text:', 'tap-and-try'); ?></p>
    <code>[tapandtry product_id="YOUR_PRODUCT_ID" text="Visualize Now"]</code>
    
    <hr>
    
    <h2><?php _e('Connection Status', 'tap-and-try'); ?></h2>
    <div id="tnt-connection-status">
        <?php if (empty(get_option('tnt_api_key'))) : ?>
            <p class="tnt-status tnt-status-disconnected">
                <span class="dashicons dashicons-warning"></span>
                <?php _e('Not connected. Please enter your API key above.', 'tap-and-try'); ?>
            </p>
        <?php else : ?>
            <p class="tnt-status tnt-status-checking">
                <span class="dashicons dashicons-update"></span>
                <?php _e('Checking connection...', 'tap-and-try'); ?>
            </p>
        <?php endif; ?>
    </div>
</div>

<style>
.tnt-status {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 15px;
    border-radius: 4px;
}
.tnt-status-disconnected {
    background: #fff3cd;
    color: #856404;
}
.tnt-status-checking {
    background: #e7f3ff;
    color: #004085;
}
.tnt-status-connected {
    background: #d4edda;
    color: #155724;
}
.tnt-status-error {
    background: #f8d7da;
    color: #721c24;
}
.tnt-status .dashicons {
    font-size: 18px;
}
.tnt-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
}
.tnt-upgrade-banner {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeeba 100%);
    border: 1px solid #ffc107;
    border-left: 4px solid #ffc107;
}
.tnt-upgrade-content {
    display: flex;
    align-items: center;
    gap: 20px;
    flex-wrap: wrap;
}
.tnt-upgrade-icon {
    flex-shrink: 0;
}
.tnt-upgrade-icon .dashicons {
    font-size: 40px;
    width: 40px;
    height: 40px;
    color: #856404;
}
.tnt-upgrade-text {
    flex: 1;
    min-width: 200px;
}
.tnt-upgrade-text h3 {
    margin: 0 0 5px;
    color: #856404;
}
.tnt-upgrade-text p {
    margin: 0;
    color: #856404;
}
.tnt-upgrade-action {
    flex-shrink: 0;
}
.tnt-upgrade-btn {
    background: #ffc107 !important;
    border-color: #e0a800 !important;
    color: #212529 !important;
    font-weight: 600;
    padding: 8px 20px !important;
}
.tnt-upgrade-btn:hover {
    background: #e0a800 !important;
}
</style>

<script>
jQuery(document).ready(function($) {
    <?php if (!empty(get_option('tnt_api_key'))) : ?>
    // Check connection
    $.post(tntAdmin.ajaxUrl, {
        action: 'tnt_get_usage',
        nonce: tntAdmin.nonce
    }, function(response) {
        var $status = $('#tnt-connection-status');
        if (response.success) {
            var maxProducts = response.data.limits.maxProducts;
            var currentProducts = response.data.usage.products;
            var isOverLimit = maxProducts !== -1 && currentProducts >= maxProducts;
            
            $status.html(
                '<p class="tnt-status tnt-status-connected">' +
                '<span class="dashicons dashicons-yes-alt"></span>' +
                'Connected! Plan: ' + response.data.plan.charAt(0).toUpperCase() + response.data.plan.slice(1) +
                ' (' + currentProducts + '/' + (maxProducts === -1 ? '∞' : maxProducts) + ' products)' +
                '</p>'
            );
            
            // Show upgrade banner if over limit
            if (isOverLimit) {
                var overBy = currentProducts - maxProducts;
                $('#tnt-settings-upgrade-message').text(
                    'You have ' + currentProducts + ' products enabled but your plan allows ' + maxProducts + '. ' +
                    'Please upgrade or disable ' + overBy + ' product(s).'
                );
                $('#tnt-settings-upgrade-banner').show();
            }
        } else {
            $status.html(
                '<p class="tnt-status tnt-status-error">' +
                '<span class="dashicons dashicons-dismiss"></span>' +
                'Connection failed. Please check your API key.' +
                '</p>'
            );
        }
    });
    <?php endif; ?>
});

function tntOpenUpgrade(redirectTo) {
    jQuery.post(tntAdmin.ajaxUrl, {
        action: 'tnt_get_login_url',
        nonce: tntAdmin.nonce,
        redirect_to: redirectTo || '/pricing'
    }, function(response) {
        if (response.success && response.data.loginUrl) {
            window.open(response.data.loginUrl, '_blank');
        } else {
            window.open('https://tapandtry.com' + (redirectTo || '/pricing'), '_blank');
        }
    }).fail(function() {
        window.open('https://tapandtry.com' + (redirectTo || '/pricing'), '_blank');
    });
}
</script>
