<?php
if (!defined('ABSPATH')) exit;

$api_key = get_option('tnt_api_key', '');
$has_api_key = !empty($api_key);

// Get WooCommerce products
$products = [];
if (class_exists('WooCommerce')) {
    $products = wc_get_products([
        'limit' => 50,
        'orderby' => 'date',
        'order' => 'DESC',
    ]);
}
?>

<div class="wrap tnt-admin">
    <h1><?php _e('Tap and Try Products', 'tap-and-try'); ?></h1>
    
    <!-- Upgrade Banner (shown when over limit) -->
    <div id="tnt-upgrade-banner" class="tnt-upgrade-banner" style="display: none;">
        <div class="tnt-upgrade-content">
            <span class="dashicons dashicons-warning"></span>
            <div class="tnt-upgrade-text">
                <strong><?php _e('Product Limit Reached', 'tap-and-try'); ?></strong>
                <span id="tnt-upgrade-message"></span>
            </div>
            <button type="button" class="button tnt-upgrade-btn" onclick="tntOpenUpgrade('/pricing')">
                <?php _e('Upgrade Plan', 'tap-and-try'); ?>
            </button>
        </div>
    </div>
    
    <?php if (!class_exists('WooCommerce')) : ?>
        <div class="notice notice-warning" style="margin: 20px 0;">
            <p>
                <strong><?php _e('WooCommerce Required', 'tap-and-try'); ?></strong><br>
                <?php _e('Product sync features require WooCommerce to be installed and activated.', 'tap-and-try'); ?>
                <?php _e('You can still manage your products directly on the', 'tap-and-try'); ?>
                <button type="button" class="button-link" onclick="tntOpenUpgrade('/dashboard/products')"><?php _e('Tap & Try Dashboard', 'tap-and-try'); ?></button>.
            </p>
        </div>
    <?php elseif (!$has_api_key) : ?>
        <div class="notice notice-warning">
            <p>
                <?php _e('Please configure your API key in', 'tap-and-try'); ?>
                <a href="<?php echo admin_url('admin.php?page=tap-and-try-settings'); ?>"><?php _e('Settings', 'tap-and-try'); ?></a>
                <?php _e('before managing products.', 'tap-and-try'); ?>
            </p>
        </div>
    <?php endif; ?>
    
    <?php if (class_exists('WooCommerce') && $has_api_key) : ?>
    
    <!-- Dashboard Link Info Box -->
    <div class="tnt-info-box">
        <div class="tnt-info-icon">
            <span class="dashicons dashicons-external"></span>
        </div>
        <div class="tnt-info-content">
            <strong><?php _e('Need to customize your products?', 'tap-and-try'); ?></strong>
            <p><?php _e('After syncing, visit your Tap & Try dashboard to upload custom images, set default backgrounds, enable Floor Mode for rugs/tiles, and more.', 'tap-and-try'); ?></p>
        </div>
        <button type="button" class="button button-primary" onclick="tntOpenUpgrade('/dashboard')">
            <?php _e('Open Dashboard', 'tap-and-try'); ?>
        </button>
    </div>
    
    <div class="tnt-products-header">
        <div class="tnt-usage-summary" id="tnt-usage-summary">
            <?php if ($has_api_key) : ?>
                <span class="tnt-loading"><?php _e('Loading usage...', 'tap-and-try'); ?></span>
            <?php endif; ?>
        </div>
        <div class="tnt-actions">
            <button id="tnt-sync-selected" class="button" disabled>
                <?php _e('Sync Selected', 'tap-and-try'); ?>
            </button>
            <button id="tnt-sync-all" class="button button-primary" <?php echo !$has_api_key ? 'disabled' : ''; ?>>
                <?php _e('Sync All Enabled', 'tap-and-try'); ?>
            </button>
        </div>
    </div>
    
    <table class="wp-list-table widefat fixed striped tnt-products-table">
        <thead>
            <tr>
                <th class="check-column">
                    <input type="checkbox" id="tnt-select-all">
                </th>
                <th class="column-thumb"><?php _e('Image', 'tap-and-try'); ?></th>
                <th class="column-name"><?php _e('Product', 'tap-and-try'); ?></th>
                <th class="column-category"><?php _e('Category', 'tap-and-try'); ?></th>
                <th class="column-status"><?php _e('Tap and Try', 'tap-and-try'); ?></th>
                <th class="column-marketplace"><?php _e('Marketplace', 'tap-and-try'); ?></th>
                <th class="column-sync"><?php _e('Sync Status', 'tap-and-try'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($products)) : ?>
                <tr>
                    <td colspan="7"><?php _e('No products found.', 'tap-and-try'); ?></td>
                </tr>
            <?php else : ?>
                <?php foreach ($products as $product) : 
                    $enabled = get_post_meta($product->get_id(), '_tnt_enabled', true) === 'yes';
                    $tnt_id = get_post_meta($product->get_id(), '_tnt_product_id', true);
                    $marketplace = get_post_meta($product->get_id(), '_tnt_marketplace', true) === 'yes';
                    $categories = wc_get_product_category_list($product->get_id());
                ?>
                <tr data-product-id="<?php echo esc_attr($product->get_id()); ?>">
                    <td class="check-column">
                        <input type="checkbox" class="tnt-product-checkbox" value="<?php echo esc_attr($product->get_id()); ?>">
                    </td>
                    <td class="column-thumb">
                        <?php echo $product->get_image([50, 50]); ?>
                    </td>
                    <td class="column-name">
                        <strong>
                            <a href="<?php echo get_edit_post_link($product->get_id()); ?>">
                                <?php echo esc_html($product->get_name()); ?>
                            </a>
                        </strong>
                    </td>
                    <td class="column-category">
                        <?php echo $categories ?: '—'; ?>
                    </td>
                    <td class="column-status">
                        <label class="tnt-toggle">
                            <input type="checkbox" 
                                   class="tnt-enable-toggle" 
                                   data-product-id="<?php echo esc_attr($product->get_id()); ?>"
                                   <?php checked($enabled); ?>
                                   <?php echo !$has_api_key ? 'disabled' : ''; ?>>
                            <span class="tnt-toggle-slider"></span>
                        </label>
                    </td>
                    <td class="column-marketplace">
                        <label class="tnt-toggle">
                            <input type="checkbox" 
                                   class="tnt-marketplace-toggle" 
                                   data-product-id="<?php echo esc_attr($product->get_id()); ?>"
                                   <?php checked($marketplace); ?>
                                   <?php echo !$enabled || !$has_api_key ? 'disabled' : ''; ?>>
                            <span class="tnt-toggle-slider"></span>
                        </label>
                    </td>
                    <td class="column-sync">
                        <?php if (!empty($tnt_id)) : ?>
                            <span class="tnt-synced" title="<?php echo esc_attr($tnt_id); ?>">
                                <span class="dashicons dashicons-yes-alt"></span>
                                <?php _e('Synced', 'tap-and-try'); ?>
                            </span>
                        <?php elseif ($enabled) : ?>
                            <span class="tnt-pending">
                                <span class="dashicons dashicons-clock"></span>
                                <?php _e('Pending', 'tap-and-try'); ?>
                            </span>
                        <?php else : ?>
                            <span class="tnt-not-enabled">—</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    
    <?php endif; ?>
</div>

<style>
.tnt-info-box {
    display: flex;
    align-items: center;
    gap: 15px;
    margin: 20px 0;
    padding: 15px 20px;
    background: linear-gradient(135deg, #f0f7ff 0%, #e8f4fd 100%);
    border: 1px solid #b8daff;
    border-left: 4px solid #2271b1;
    border-radius: 4px;
}
.tnt-info-icon {
    flex-shrink: 0;
}
.tnt-info-icon .dashicons {
    font-size: 24px;
    width: 24px;
    height: 24px;
    color: #2271b1;
}
.tnt-info-content {
    flex: 1;
}
.tnt-info-content strong {
    display: block;
    margin-bottom: 4px;
    color: #1d4ed8;
}
.tnt-info-content p {
    margin: 0;
    color: #4b5563;
    font-size: 13px;
}
.tnt-products-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin: 20px 0;
    padding: 15px;
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
}
.tnt-usage-summary {
    font-size: 14px;
}
.tnt-usage-summary strong {
    color: #667eea;
}
.tnt-actions {
    display: flex;
    gap: 10px;
}
.tnt-products-table .column-thumb {
    width: 60px;
}
.tnt-products-table .column-status,
.tnt-products-table .column-marketplace {
    width: 100px;
    text-align: center;
}
.tnt-products-table .column-sync {
    width: 120px;
}
.tnt-toggle {
    position: relative;
    display: inline-block;
    width: 44px;
    height: 24px;
}
.tnt-toggle input {
    opacity: 0;
    width: 0;
    height: 0;
}
.tnt-toggle-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .3s;
    border-radius: 24px;
}
.tnt-toggle-slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: .3s;
    border-radius: 50%;
}
.tnt-toggle input:checked + .tnt-toggle-slider {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}
.tnt-toggle input:checked + .tnt-toggle-slider:before {
    transform: translateX(20px);
}
.tnt-toggle input:disabled + .tnt-toggle-slider {
    opacity: 0.5;
    cursor: not-allowed;
}
.tnt-synced {
    color: #46b450;
    display: flex;
    align-items: center;
    gap: 4px;
}
.tnt-pending {
    color: #f0ad4e;
    display: flex;
    align-items: center;
    gap: 4px;
}
.tnt-not-enabled {
    color: #999;
}
.tnt-loading {
    color: #666;
}
.tnt-upgrade-banner {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeeba 100%);
    border: 1px solid #ffc107;
    border-left: 4px solid #ffc107;
    padding: 15px 20px;
    margin-bottom: 20px;
    border-radius: 4px;
}
.tnt-upgrade-content {
    display: flex;
    align-items: center;
    gap: 15px;
    flex-wrap: wrap;
}
.tnt-upgrade-content .dashicons {
    font-size: 24px;
    width: 24px;
    height: 24px;
    color: #856404;
}
.tnt-upgrade-text {
    flex: 1;
    color: #856404;
}
.tnt-upgrade-text strong {
    display: block;
    margin-bottom: 2px;
}
.tnt-upgrade-btn {
    background: #ffc107 !important;
    border-color: #e0a800 !important;
    color: #212529 !important;
    font-weight: 600;
}
.tnt-upgrade-btn:hover {
    background: #e0a800 !important;
}
.tnt-usage-over-limit {
    color: #dc3545 !important;
    font-weight: bold;
}
.tnt-toggle-disabled-msg {
    font-size: 11px;
    color: #856404;
    display: block;
    margin-top: 4px;
}
</style>

<script>
jQuery(document).ready(function($) {
    // Load usage
    <?php if ($has_api_key) : ?>
    $.post(tntAdmin.ajaxUrl, {
        action: 'tnt_get_usage',
        nonce: tntAdmin.nonce
    }, function(response) {
        if (response.success) {
            var data = response.data;
            var limit = data.limits.maxProducts === -1 ? '∞' : data.limits.maxProducts;
            var isOverLimit = data.limits.maxProducts > 0 && data.usage.products > data.limits.maxProducts;
            var isAtLimit = data.limits.maxProducts > 0 && data.usage.products >= data.limits.maxProducts;
            
            var usageClass = isOverLimit ? ' class="tnt-usage-over-limit"' : '';
            $('#tnt-usage-summary').html(
                '<span' + usageClass + '><strong>' + data.usage.products + '</strong> / ' + limit + ' products</span> ' +
                '(<strong>' + data.plan.charAt(0).toUpperCase() + data.plan.slice(1) + '</strong> plan)' +
                (isAtLimit && !isOverLimit ? ' <em>- Limit reached</em>' : '')
            );
            
            // Store limit state for toggle logic
            window.tntIsOverLimit = isOverLimit;
            window.tntIsAtLimit = isAtLimit;
            window.tntPlan = data.plan;
            window.tntLimit = data.limits.maxProducts;
            window.tntUsage = data.usage.products;
            
            // Show upgrade banner if over limit
            if (isOverLimit) {
                $('#tnt-upgrade-message').text(
                    'You have ' + data.usage.products + ' products but your plan allows ' + data.limits.maxProducts + '. ' +
                    'You cannot enable more products until you upgrade.'
                );
                $('#tnt-upgrade-banner').slideDown();
                
                // Disable all "enable" toggles for products not already enabled
                $('.tnt-enable-toggle:not(:checked)').each(function() {
                    $(this).prop('disabled', true);
                    $(this).closest('td').append('<span class="tnt-toggle-disabled-msg">Upgrade to enable</span>');
                });
            } else if (isAtLimit) {
                // At limit but not over - disable toggles for non-enabled products
                $('.tnt-enable-toggle:not(:checked)').each(function() {
                    $(this).prop('disabled', true);
                    $(this).closest('td').append('<span class="tnt-toggle-disabled-msg">Limit reached</span>');
                });
            }
        }
    });
    <?php endif; ?>
    
    // Select all
    $('#tnt-select-all').on('change', function() {
        $('.tnt-product-checkbox').prop('checked', $(this).is(':checked'));
        updateSyncButton();
    });
    
    $('.tnt-product-checkbox').on('change', updateSyncButton);
    
    function updateSyncButton() {
        var checked = $('.tnt-product-checkbox:checked').length;
        $('#tnt-sync-selected').prop('disabled', checked === 0).text(
            checked > 0 ? 'Sync Selected (' + checked + ')' : 'Sync Selected'
        );
    }
    
    // Toggle enable
    $('.tnt-enable-toggle').on('change', function() {
        var $toggle = $(this);
        var productId = $toggle.data('product-id');
        var enabled = $toggle.is(':checked') ? 'yes' : 'no';
        var $row = $toggle.closest('tr');
        var $marketplaceToggle = $row.find('.tnt-marketplace-toggle');
        
        // Check if trying to enable when at/over limit
        if (enabled === 'yes' && window.tntIsAtLimit) {
            $toggle.prop('checked', false);
            alert('You have reached your product limit (' + window.tntLimit + ' products). Please upgrade your plan to enable more products.');
            return;
        }
        
        $marketplaceToggle.prop('disabled', !$toggle.is(':checked'));
        
        $.post(tntAdmin.ajaxUrl, {
            action: 'tnt_toggle_product',
            nonce: tntAdmin.nonce,
            product_id: productId,
            enabled: enabled
        }, function(response) {
            if (response.success && enabled === 'yes') {
                $row.find('.column-sync').html(
                    '<span class="tnt-synced"><span class="dashicons dashicons-yes-alt"></span>Synced</span>'
                );
                // Update usage count
                if (window.tntUsage !== undefined) {
                    window.tntUsage++;
                    window.tntIsAtLimit = window.tntLimit > 0 && window.tntUsage >= window.tntLimit;
                }
            } else if (response.success && enabled === 'no') {
                // Update usage count when disabling
                if (window.tntUsage !== undefined && window.tntUsage > 0) {
                    window.tntUsage--;
                    window.tntIsAtLimit = window.tntLimit > 0 && window.tntUsage >= window.tntLimit;
                    window.tntIsOverLimit = window.tntLimit > 0 && window.tntUsage > window.tntLimit;
                }
            }
        });
    });
    
    // Toggle marketplace visibility
    $('.tnt-marketplace-toggle').on('change', function() {
        var $toggle = $(this);
        var productId = $toggle.data('product-id');
        var marketplace = $toggle.is(':checked') ? 'yes' : 'no';
        var $row = $toggle.closest('tr');
        
        $.post(tntAdmin.ajaxUrl, {
            action: 'tnt_toggle_product',
            nonce: tntAdmin.nonce,
            product_id: productId,
            enabled: $row.find('.tnt-enable-toggle').is(':checked') ? 'yes' : 'no',
            marketplace: marketplace
        }, function(response) {
            if (!response.success) {
                // Revert toggle on failure
                $toggle.prop('checked', !$toggle.is(':checked'));
                alert(response.data?.message || 'Failed to update marketplace visibility');
            }
        });
    });
    
    // Auto-login redirect helper
    window.tntOpenUpgrade = function(redirectTo) {
        $.post(tntAdmin.ajaxUrl, {
            action: 'tnt_get_login_url',
            nonce: tntAdmin.nonce,
            redirect_to: redirectTo || '/pricing'
        }, function(response) {
            if (response.success && response.data.loginUrl) {
                window.open(response.data.loginUrl, '_blank');
            } else {
                window.open('https://tapandtry.com' + (redirectTo || '/pricing'), '_blank');
            }
        }).fail(function() {
            window.open('https://tapandtry.com' + (redirectTo || '/pricing'), '_blank');
        });
    };
    
    // Sync all
    $('#tnt-sync-all').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).text('Syncing...');
        
        $.post(tntAdmin.ajaxUrl, {
            action: 'tnt_sync_products',
            nonce: tntAdmin.nonce
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
                location.reload();
            } else {
                alert('Sync failed. Please try again.');
            }
            $btn.prop('disabled', false).text('Sync All Enabled');
        });
    });
});
</script>
